/*
 * Copyright (c) 2008-2016, RF-Embedded GmbH
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *
 *  1. Redistributions of source code must retain the above copyright notice,
 *     this list of conditions and the following disclaimer.
 *  2. Redistributions in binary form must reproduce the above copyright notice,
 *     this list of conditions and the following disclaimer in the
 *     documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT
 * SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT
 * OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR
 * TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include "CPPrfeTagEvent.h"

#include <sstream>

#include "../helper/StringHelper.h"

using namespace CPPrfeReaderInterface;

CPPrfeTagEvent::CPPrfeTagEvent()
{
    hasAntenna = false;
    hasRSSI = false;
    hasReadFrequency = false;
    hasMemory = false;
    hasTrigger = false;
    hasHandle = false;
    hasState = false;
    hasBattery = false;
    hasPC = false;
    hasMessageId = false;
    hasApplicationInfo = false;
}

CPPrfeTagEvent::CPPrfeTagEvent(const CPPrfeTagEvent &other)
{
    tagId = other.tagId;

    hasAntenna = other.hasAntenna;
    if (hasAntenna)
    {
        antennaId = other.antennaId;
    }

    hasRSSI = other.hasRSSI;
    if (hasRSSI)
    {
        rssi = other.rssi;
    }

    hasReadFrequency = other.hasReadFrequency;
    if (hasReadFrequency)
    {
        readFrequency = other.readFrequency;
    }

    hasMemory = other.hasMemory;
    if (hasMemory)
    {
        memBank = other.memBank;
        memAddr = other.memAddr;
        memData = other.memData;
    }

    hasTrigger = other.hasTrigger;
    if (hasTrigger)
    {
        trigger = other.trigger;
    }

    hasHandle = other.hasHandle;
    if (hasHandle)
    {
        handle = other.handle;
    }

    hasState = other.hasState;
    if (hasState)
    {
        state = other.state;
    }

    hasBattery = other.hasBattery;
    if (hasBattery)
    {
        battery = other.battery;
    }

    hasPC = other.hasPC;
    if (hasBattery)
    {
        pc = other.pc;
    }

    hasMessageId = other.hasMessageId;
    if (hasMessageId)
    {
        messageId = other.messageId;
    }

    hasApplicationInfo = other.hasApplicationInfo;
    if (hasApplicationInfo)
    {
        applicationInfo = other.applicationInfo;
    }
}

std::string CPPrfeTagEvent::toString()
{
    std::stringstream ret;

    ret << StringHelper::toString(tagId);
    ret << ", ";

    if (hasAntenna)
    {
        ret << "Antenna #" << antennaId << ", ";
    }

    if (hasRSSI)
    {
        ret << "RSSI " << StringHelper::toString(rssi) << ", ";
    }

    if (hasReadFrequency)
    {
        ret << "Frequency " << readFrequency << ", ";
    }

    if (hasMemory)
    {
        ret << "Data " << memBank << "@" << memAddr << StringHelper::toString(memData) << ", ";
    }

    if (hasTrigger)
    {
        ret << "Trigger " << trigger << ", ";
    }

    if (hasHandle)
    {
        ret << "Handle " << StringHelper::toString(handle) << ", ";
    }

    if (hasState)
    {
        ret << "State " << state << ", ";
    }

    if (hasBattery)
    {
        ret << "Battery " << battery << ", ";
    }

    if (hasPC)
    {
        ret << "PC " << StringHelper::toString(pc) << ", ";
    }

    if (hasMessageId)
    {
        ret << "MessageID " << messageId << ", ";
    }

    if (hasApplicationInfo)
    {
        ret << "ApplicationInfo " << StringHelper::toString(applicationInfo) << ", ";
    }

    return ret.str();
}
